<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['title', 'subtitle' => null, 'ctaText', 'ctaUrl', 'image' => null]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['title', 'subtitle' => null, 'ctaText', 'ctaUrl', 'image' => null]); ?>
<?php foreach (array_filter((['title', 'subtitle' => null, 'ctaText', 'ctaUrl', 'image' => null]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<!-- CTA Banner avec Image -->
<section class="relative py-24 overflow-hidden">
    <!-- Background -->
    <?php if($image): ?>
        <div class="absolute inset-0">
            <img src="<?php echo e(asset('images/' . $image)); ?>" alt="" class="w-full h-full object-cover">
            <div class="absolute inset-0 bg-gradient-to-r from-primary-900/95 to-primary-800/90"></div>
        </div>
    <?php else: ?>
        <div class="absolute inset-0 bg-gradient-to-r from-primary-900 to-primary-800"></div>
    <?php endif; ?>

    <!-- Content -->
    <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl sm:text-4xl lg:text-5xl font-bold text-white mb-6">
            <?php echo e($title); ?>

        </h2>
        <?php if($subtitle): ?>
            <p class="text-xl text-primary-100 mb-10 max-w-2xl mx-auto">
                <?php echo e($subtitle); ?>

            </p>
        <?php endif; ?>
        <a href="<?php echo e($ctaUrl); ?>"
           class="inline-flex items-center px-10 py-5 bg-white text-primary-900 text-lg font-bold rounded-lg hover:bg-primary-50 transition shadow-2xl hover:shadow-3xl">
            <?php echo e($ctaText); ?>

            <svg class="w-6 h-6 ml-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
            </svg>
        </a>
    </div>
</section>
<?php /**PATH C:\wamp64\www\madacademie\resources\views/components/cta-banner.blade.php ENDPATH**/ ?>