@extends('layouts.front')

@section('content')

<!-- Page Hero -->
<x-page-hero
    title="Nos formations"
    subtitle="Des parcours professionnels, orientés pratique, pour développer des compétences solides et recherchées."
    :breadcrumb="true" />

<!-- Introduction -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-3 gap-8 items-start">
            <!-- Description principale -->
            <div class="lg:col-span-2">
                <div class="inline-block px-4 py-2 bg-primary-50 text-primary-700 text-sm font-semibold rounded-full mb-4">
                    Formations professionnelles
                </div>
                <h2 class="text-3xl font-bold text-slate-900 mb-4 font-serif tracking-tight leading-tight">
                    Choisissez une filière, développez des compétences concrètes
                </h2>
                <p class="text-lg text-slate-600 leading-relaxed mb-4">
                    Mad Academy propose des filières professionnelles structurées, conçues pour apprendre un métier et devenir opérationnel. L’accent est mis sur la pratique, la méthode et la rigueur.
                </p>
                <p class="text-slate-600 leading-relaxed">
                    Chaque formation intègre des exercices, ateliers et mises en situation, avec un accompagnement pour faciliter l’orientation et l’insertion.
                </p>
            </div>

            <!-- Informations clés -->
            <div class="bg-slate-50 rounded-2xl p-8 border-2 border-slate-200">
                <h3 class="text-xl font-bold text-slate-900 mb-6 font-serif tracking-tight leading-tight">Informations clés</h3>
                <div class="space-y-6">
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-12 h-12 bg-primary-100 rounded-xl flex items-center justify-center">
                            <svg class="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div>
                            <div class="font-semibold text-slate-900 mb-1">Durée</div>
                            <div class="text-slate-600 text-sm">3 mois à 1 an (selon filière)</div>
                        </div>
                    </div>

                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-12 h-12 bg-primary-100 rounded-xl flex items-center justify-center">
                            <svg class="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"/>
                            </svg>
                        </div>
                        <div>
                            <div class="font-semibold text-slate-900 mb-1">Certifications</div>
                            <div class="text-slate-600 text-sm">DQP / CQP / AQP (selon parcours)</div>
                        </div>
                    </div>

                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-12 h-12 bg-primary-100 rounded-xl flex items-center justify-center">
                            <svg class="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <div>
                            <div class="font-semibold text-slate-900 mb-1">Approche</div>
                            <div class="text-slate-600 text-sm">Pratique encadrée + suivi personnalisé</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Programmes Grid avec Filtres -->
<section class="py-20 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="text-center mb-12">
            <h2 class="text-3xl sm:text-4xl font-bold text-slate-900 mb-4 font-serif tracking-tight leading-tight">
                Explorez nos filières
            </h2>
            <p class="text-lg text-slate-600 max-w-2xl mx-auto">
                Trouvez la formation qui correspond à votre profil et à votre projet professionnel.
            </p>
        </div>

        @if($programmes->isNotEmpty())
            <!-- Filtres Alpine.js -->
            <div class="mb-12" x-data="{ activeFilter: 'tous' }">
                <div class="flex flex-wrap gap-3 justify-center">
                    <button @click="activeFilter = 'tous'"
                            :class="activeFilter === 'tous' ? 'bg-primary-600 text-white' : 'bg-white text-slate-700 hover:bg-slate-50'"
                            class="px-6 py-2 rounded-full font-medium transition shadow-sm">
                        Toutes les filières
                    </button>
                    <button @click="activeFilter = 'Bac+2'"
                            :class="activeFilter === 'Bac+2' ? 'bg-primary-600 text-white' : 'bg-white text-slate-700 hover:bg-slate-50'"
                            class="px-6 py-2 rounded-full font-medium transition shadow-sm">
                        Imprimerie
                    </button>
                    <button @click="activeFilter = 'Bac+3'"
                            :class="activeFilter === 'Bac+3' ? 'bg-primary-600 text-white' : 'bg-white text-slate-700 hover:bg-slate-50'"
                            class="px-6 py-2 rounded-full font-medium transition shadow-sm">
                        Informatique
                    </button>
                    <button @click="activeFilter = 'Bac+5'"
                            :class="activeFilter === 'Bac+5' ? 'bg-primary-600 text-white' : 'bg-white text-slate-700 hover:bg-slate-50'"
                            class="px-6 py-2 rounded-full font-medium transition shadow-sm">
                        Gestion & Numérique
                    </button>
                </div>

                <!-- Grid des programmes -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mt-8">
                    @foreach($programmes as $programme)
                        <div x-show="activeFilter === 'tous' || activeFilter === '{{ $programme->niveau }}'"
                             x-transition:enter="transition ease-out duration-300"
                             x-transition:enter-start="opacity-0 transform scale-95"
                             x-transition:enter-end="opacity-100 transform scale-100"
                             x-transition:leave="transition ease-in duration-200"
                             x-transition:leave-start="opacity-100 transform scale-100"
                             x-transition:leave-end="opacity-0 transform scale-95">
                            <x-programme-card :programme="$programme" />
                        </div>
                    @endforeach
                </div>
            </div>
        @else
            <!-- Empty State -->
            <div class="text-center py-16">
                <div class="bg-white rounded-2xl p-12 shadow-sm max-w-md mx-auto">
                    <div class="w-20 h-20 bg-slate-100 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-slate-900 mb-2 font-serif tracking-tight leading-tight">Aucune formation disponible</h3>
                    <p class="text-slate-500 mb-6">Les formations seront affichées ici dès leur publication. Contactez-nous pour être orienté.</p>
                    <a href="{{ route('contact') }}"
                       class="inline-flex items-center px-6 py-3 bg-red-600 hover:bg-red-700 text-white font-semibold tracking-tight rounded-lg transition">
                        Nous contacter
                        <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                        </svg>
                    </a>
                </div>
            </div>
        @endif
    </div>
</section>

<!-- Section Aide & Orientation -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-gradient-to-br from-primary-900 via-primary-800 to-primary-900 rounded-3xl overflow-hidden shadow-2xl">
            <div class="grid lg:grid-cols-2 gap-8 items-center">
                <!-- Contenu -->
                <div class="p-8 lg:p-12">
                    <div class="inline-block px-4 py-2 bg-white/10 text-white text-sm font-semibold rounded-full mb-4">
                        Orientation
                    </div>
                    <h2 class="text-3xl sm:text-4xl font-bold text-white mb-6 font-serif tracking-tight leading-tight">
                        Vous hésitez ? Nous vous aidons à choisir
                    </h2>
                    <p class="text-primary-100 text-lg leading-relaxed mb-8">
                        Notre équipe vous oriente gratuitement vers la filière la plus adaptée à votre profil, vos objectifs et votre calendrier. Un conseil clair, pratique et personnalisé.
                    </p>

                    <!-- Points clés -->
                    <div class="space-y-3 mb-8">
                        <div class="flex items-center gap-3 text-white">
                            <svg class="w-5 h-5 text-primary-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            <span>Conseil d’orientation gratuit</span>
                        </div>
                        <div class="flex items-center gap-3 text-white">
                            <svg class="w-5 h-5 text-primary-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            <span>Accompagnement dans vos démarches</span>
                        </div>
                        <div class="flex items-center gap-3 text-white">
                            <svg class="w-5 h-5 text-primary-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            <span>Visite guidée des infrastructures</span>
                        </div>
                    </div>

                    <a href="{{ route('contact') }}"
                       class="inline-flex items-center px-8 py-4 bg-white hover:bg-primary-50 text-primary-900 text-lg font-semibold tracking-tight rounded-lg transition shadow-lg hover:shadow-xl">
                        Demander une orientation
                        <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                        </svg>
                    </a>
                </div>

                <!-- Statistiques (si disponibles) -->
                @if(isset($statistics) && $statistics->count() > 0)
                <div class="p-8 lg:p-12 bg-white/5 backdrop-blur-sm">
                    <h3 class="text-2xl font-bold text-white mb-8 font-serif tracking-tight leading-tight">Repères</h3>
                    <div class="grid grid-cols-2 gap-6">
                        @foreach($statistics->take(4) as $stat)
                        <div class="text-center">
                            <div class="flex justify-center mb-3">
                                @if($stat->icone == 'chart')
                                <svg class="w-8 h-8 text-primary-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                                </svg>
                                @elseif($stat->icone == 'briefcase')
                                <svg class="w-8 h-8 text-primary-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 13.255A23.931 23.931 0 0112 15c-3.183 0-6.22-.62-9-1.745M16 6V4a2 2 0 00-2-2h-4a2 2 0 00-2 2v2m4 6h.01M5 20h14a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                </svg>
                                @elseif($stat->icone == 'users')
                                <svg class="w-8 h-8 text-primary-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                                </svg>
                                @else
                                <svg class="w-8 h-8 text-primary-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"/>
                                </svg>
                                @endif
                            </div>
                            <div class="text-4xl font-bold text-white mb-2">{{ $stat->valeur }}</div>
                            <div class="text-primary-200 text-sm">{{ $stat->libelle }}</div>
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</section>

<!-- CTA Final -->
<x-cta-banner
    title="Prêt à démarrer votre formation ?"
    subtitle="Déposez votre candidature et recevez un accompagnement pour finaliser votre dossier. Nous vous répondons rapidement."
    ctaText="Déposer ma candidature"
    ctaUrl="{{ route('inscription') }}" />

@endsection
