@extends('layouts.front')

@section('content')

<!-- Page Hero -->
<x-page-hero
    title="Inscription"
    subtitle="Faites le premier pas : démarrez votre inscription et construisez votre projet professionnel avec Mad Academy."
    :breadcrumb="true" />

<!-- Stepper - Processus d'inscription -->
<section class="py-12 bg-white border-b border-slate-200">
    <x-stepper
        :steps="[
            ['label' => 'Formulaire', 'description' => 'Informations personnelles'],
            ['label' => 'Vérification', 'description' => 'Examen du dossier'],
            ['label' => 'Contact', 'description' => 'Finalisation'],
            ['label' => 'Validation', 'description' => 'Bienvenue à Mad Academy']
        ]"
        :currentStep="1" />
</section>

<!-- Formulaire d'inscription -->
<section class="py-16 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-3 gap-8">
            <!-- Formulaire (70%) -->
            <div class="lg:col-span-2">
                <div class="bg-white rounded-2xl shadow-lg p-8 md:p-10">
                    <!-- Header -->
                    <div class="mb-8">
                        <h2 class="text-2xl sm:text-3xl font-bold text-slate-900 mb-3 font-serif tracking-tight leading-tight">
                            Formulaire d’inscription
                        </h2>
                        <p class="text-lg text-slate-600">
                            Remplissez ce formulaire pour démarrer votre inscription. Nous vous contactons rapidement pour finaliser votre dossier.
                        </p>
                    </div>

                    <!-- Success Message -->
                    @if(session('success'))
                        <div class="bg-green-50 border-2 border-green-200 rounded-xl p-5 mb-8 flex items-start gap-4">
                            <div class="flex-shrink-0 w-10 h-10 bg-green-100 rounded-full flex items-center justify-center">
                                <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="font-bold text-green-800 text-lg mb-1 font-serif tracking-tight leading-tight">Inscription envoyée avec succès !</h3>
                                <p class="text-green-700">{{ session('success') }}</p>
                            </div>
                        </div>
                    @endif

                    <!-- Form -->
                    <form method="POST" action="{{ route('inscription.store') }}" class="space-y-8">
                        @csrf

                        <!-- Section 1: Informations personnelles -->
                        <div class="pb-8 border-b border-slate-200">
                            <h3 class="text-xl font-bold text-slate-900 mb-6 flex items-center gap-3 font-serif tracking-tight leading-tight">
                                <span class="flex-shrink-0 w-10 h-10 bg-primary-100 text-primary-700 rounded-xl flex items-center justify-center font-bold">1</span>
                                Informations personnelles
                            </h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- Nom -->
                                <div>
                                    <label for="nom" class="block text-sm font-semibold text-slate-700 mb-2">
                                        Nom <span class="text-red-500">*</span>
                                    </label>
                                    <input type="text" name="nom" id="nom" value="{{ old('nom') }}" required
                                        class="w-full px-4 py-3 border-2 border-slate-200 rounded-xl focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition @error('nom') border-red-500 @enderror"
                                        placeholder="Votre nom">
                                    @error('nom')
                                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>

                                <!-- Prénom -->
                                <div>
                                    <label for="prenom" class="block text-sm font-semibold text-slate-700 mb-2">
                                        Prénom <span class="text-red-500">*</span>
                                    </label>
                                    <input type="text" name="prenom" id="prenom" value="{{ old('prenom') }}" required
                                        class="w-full px-4 py-3 border-2 border-slate-200 rounded-xl focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition @error('prenom') border-red-500 @enderror"
                                        placeholder="Votre prénom">
                                    @error('prenom')
                                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Section 2: Coordonnées -->
                        <div class="pb-8 border-b border-slate-200">
                            <h3 class="text-xl font-bold text-slate-900 mb-6 flex items-center gap-3 font-serif tracking-tight leading-tight">
                                <span class="flex-shrink-0 w-10 h-10 bg-primary-100 text-primary-700 rounded-xl flex items-center justify-center font-bold">2</span>
                                Coordonnées
                            </h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <!-- Email -->
                                <div>
                                    <label for="email" class="block text-sm font-semibold text-slate-700 mb-2">
                                        Adresse email <span class="text-red-500">*</span>
                                    </label>
                                    <input type="email" name="email" id="email" value="{{ old('email') }}" required
                                        class="w-full px-4 py-3 border-2 border-slate-200 rounded-xl focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition @error('email') border-red-500 @enderror"
                                        placeholder="votre@email.com">
                                    @error('email')
                                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>

                                <!-- Téléphone -->
                                <div>
                                    <label for="telephone" class="block text-sm font-semibold text-slate-700 mb-2">
                                        Numéro de téléphone <span class="text-red-500">*</span>
                                    </label>
                                    <input type="text" name="telephone" id="telephone" value="{{ old('telephone') }}" required
                                        class="w-full px-4 py-3 border-2 border-slate-200 rounded-xl focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition @error('telephone') border-red-500 @enderror"
                                        placeholder="6XX XXX XXX">
                                    @error('telephone')
                                        <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                            {{ $message }}
                                        </p>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Section 3: Choix du programme -->
                        <div class="pb-8 border-b border-slate-200">
                            <h3 class="text-xl font-bold text-slate-900 mb-6 flex items-center gap-3 font-serif tracking-tight leading-tight">
                                <span class="flex-shrink-0 w-10 h-10 bg-primary-100 text-primary-700 rounded-xl flex items-center justify-center font-bold">3</span>
                                Choix de la formation
                            </h3>
                            <div>
                                <label for="programme_id" class="block text-sm font-semibold text-slate-700 mb-2">
                                    Formation souhaitée <span class="text-red-500">*</span>
                                </label>
                                <select name="programme_id" id="programme_id" required
                                    class="w-full px-4 py-3 border-2 border-slate-200 rounded-xl focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition @error('programme_id') border-red-500 @enderror">
                                    <option value="">-- Sélectionnez une formation --</option>
                                    @foreach($programmes as $programme)
                                        <option value="{{ $programme->id }}" {{ (old('programme_id', $programmeId) == $programme->id) ? 'selected' : '' }}>
                                            {{ $programme->titre }} ({{ $programme->niveau }}) - {{ number_format($programme->pension, 0, ',', ' ') }} FCFA/an
                                        </option>
                                    @endforeach
                                </select>
                                @error('programme_id')
                                    <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>
                        </div>

                        <!-- Section 4: Message optionnel -->
                        <div>
                            <h3 class="text-xl font-bold text-slate-900 mb-6 flex items-center gap-3 font-serif tracking-tight leading-tight">
                                <span class="flex-shrink-0 w-10 h-10 bg-slate-100 text-slate-600 rounded-xl flex items-center justify-center font-bold">4</span>
                                Message (optionnel)
                            </h3>
                            <div>
                                <label for="message" class="block text-sm font-semibold text-slate-700 mb-2">
                                    Votre message
                                </label>
                                <textarea name="message" id="message" rows="5"
                                    class="w-full px-4 py-3 border-2 border-slate-200 rounded-xl focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition resize-none @error('message') border-red-500 @enderror"
                                    placeholder="Parlez-nous brièvement de votre projet, vos motivations et vos objectifs…">{{ old('message') }}</textarea>
                                @error('message')
                                    <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="pt-4">
                            <button type="submit"
                                class="w-full bg-red-600 hover:bg-red-700 text-white text-lg font-bold tracking-tight py-4 px-8 rounded-xl transition shadow-lg hover:shadow-xl flex items-center justify-center gap-3 group">
                                <span>Envoyer ma demande</span>
                                <svg class="w-6 h-6 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                                </svg>
                            </button>
                            <p class="text-sm text-slate-500 text-center mt-4">
                                Les champs marqués d’un <span class="text-red-500">*</span> sont obligatoires
                            </p>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Sidebar (30%) -->
            <div class="lg:col-span-1 space-y-6">

                <!-- Documents requis -->
                @if($documentsRequis->count() > 0)
                <div class="bg-white rounded-2xl shadow-lg p-6">
                    <div class="flex items-center gap-3 mb-6">
                        <div class="w-10 h-10 bg-primary-100 rounded-xl flex items-center justify-center">
                            <svg class="w-6 h-6 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-slate-900 font-serif tracking-tight leading-tight">Dossier à fournir</h3>
                    </div>
                    <ul class="space-y-3">
                        @foreach($documentsRequis as $document)
                        <li class="flex items-start gap-3 text-sm">
                            <svg class="w-5 h-5 text-green-500 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            <div class="text-slate-700">
                                <span class="font-medium">{{ $document->intitule }}</span>
                                @if($document->description)
                                    <p class="text-xs text-slate-500 mt-1">{{ $document->description }}</p>
                                @endif
                            </div>
                        </li>
                        @endforeach
                    </ul>
                    <div class="mt-6 p-4 bg-primary-50 rounded-xl">
                        <p class="text-sm text-primary-800">
                            <strong>Note :</strong> Ces pièces seront demandées lors de la finalisation de l’inscription.
                        </p>
                    </div>
                </div>
                @endif

                <!-- Contact Card -->
                <div class="bg-gradient-to-br from-primary-900 via-primary-800 to-primary-900 rounded-2xl shadow-lg p-6 text-white">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="w-10 h-10 bg-white/10 rounded-xl flex items-center justify-center">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold font-serif tracking-tight leading-tight">Besoin d'aide ?</h3>
                    </div>
                    <p class="text-primary-100 text-sm mb-6 leading-relaxed">
                        Notre équipe répond à vos questions et vous accompagne dans le processus d’inscription.
                    </p>
                    <div class="space-y-3">
                        <a href="tel:+237600000000" class="flex items-center gap-3 p-3 bg-white/10 rounded-lg hover:bg-white/20 transition">
                            <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                            </svg>
                            <span>+237 675 65 81 65</span>
                        </a>
                        <a href="mailto:info@madacademy.xx" class="flex items-center gap-3 p-3 bg-white/10 rounded-lg hover:bg-white/20 transition">
                            <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                            <span>info@madacademy.cm</span>
                        </a>
                    </div>
                </div>

                <!-- Help Card -->
                <div class="bg-white rounded-2xl shadow-lg p-6">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="w-10 h-10 bg-blue-100 rounded-xl flex items-center justify-center">
                            <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-slate-900 font-serif tracking-tight leading-tight">Délais</h3>
                    </div>
                    <p class="text-slate-600 text-sm leading-relaxed">
                        Votre demande est traitée rapidement. Vous recevrez un retour dès l’étude de votre dossier.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection
