@extends('layouts.front')

@section('content')

<!-- Page Hero -->
<x-page-hero
    title="Contactez-nous"
    subtitle="Une question, une orientation, une inscription ? Notre équipe est à votre écoute."
    :breadcrumb="true" />

<!-- Contact Section -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-5 gap-12">
            <!-- Form Column (60% - 3 cols) -->
            <div class="lg:col-span-3">
                <div class="bg-white rounded-2xl shadow-lg border-2 border-slate-100 p-8 md:p-10">
                    <!-- Header -->
                    <div class="mb-8">
                        <h2 class="text-2xl sm:text-3xl font-bold text-slate-900 mb-3 font-serif tracking-tight leading-tight">
                            Envoyez-nous un message
                        </h2>
                        <p class="text-lg text-slate-600">
                            Remplissez le formulaire ci-dessous. Nous vous répondrons dans les meilleurs délais.
                        </p>
                    </div>

                    <!-- Success Message -->
                    @if(session('success'))
                        <div class="bg-green-50 border-2 border-green-200 rounded-xl p-5 mb-8 flex items-start gap-4">
                            <div class="flex-shrink-0 w-10 h-10 bg-green-100 rounded-full flex items-center justify-center">
                                <svg class="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="font-bold text-green-800 text-lg mb-1 font-serif tracking-tight leading-tight">Message envoyé avec succès !</h3>
                                <p class="text-green-700">{{ session('success') }}</p>
                            </div>
                        </div>
                    @endif

                    <!-- Form -->
                    <form method="POST" action="{{ route('contact.store') }}" class="space-y-6">
                        @csrf

                        <!-- Nom & Email -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Nom -->
                            <div>
                                <label for="nom" class="block text-sm font-semibold text-slate-700 mb-2">
                                    Nom complet <span class="text-red-500">*</span>
                                </label>
                                <input type="text" name="nom" id="nom" value="{{ old('nom') }}" required
                                    class="w-full px-4 py-3 border-2 border-slate-200 rounded-xl focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition @error('nom') border-red-500 @enderror"
                                    placeholder="Votre nom et prénom">
                                @error('nom')
                                    <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>

                            <!-- Email -->
                            <div>
                                <label for="email" class="block text-sm font-semibold text-slate-700 mb-2">
                                    Adresse email <span class="text-red-500">*</span>
                                </label>
                                <input type="email" name="email" id="email" value="{{ old('email') }}" required
                                    class="w-full px-4 py-3 border-2 border-slate-200 rounded-xl focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition @error('email') border-red-500 @enderror"
                                    placeholder="votre@email.com">
                                @error('email')
                                    <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                        {{ $message }}
                                    </p>
                                @enderror
                            </div>
                        </div>

                        <!-- Sujet -->
                        <div>
                            <label for="sujet" class="block text-sm font-semibold text-slate-700 mb-2">
                                Sujet <span class="text-red-500">*</span>
                            </label>
                            <input type="text" name="sujet" id="sujet" value="{{ old('sujet') }}" required
                                class="w-full px-4 py-3 border-2 border-slate-200 rounded-xl focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition @error('sujet') border-red-500 @enderror"
                                placeholder="Objet de votre message">
                            @error('sujet')
                                <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                    {{ $message }}
                                </p>
                            @enderror
                        </div>

                        <!-- Message -->
                        <div>
                            <label for="message" class="block text-sm font-semibold text-slate-700 mb-2">
                                Votre message <span class="text-red-500">*</span>
                            </label>
                            <textarea name="message" id="message" rows="6" required
                                class="w-full px-4 py-3 border-2 border-slate-200 rounded-xl focus:border-primary-500 focus:ring-4 focus:ring-primary-500/10 transition resize-none @error('message') border-red-500 @enderror"
                                placeholder="Écrivez votre message ici…">{{ old('message') }}</textarea>
                            @error('message')
                                <p class="mt-2 text-sm text-red-600 flex items-center gap-1">
                                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                                    {{ $message }}
                                </p>
                            @enderror
                        </div>

                        <!-- Submit Button -->
                        <div class="pt-2">
                            <button type="submit"
                                class="w-full bg-red-600 hover:bg-red-700 text-white text-lg font-bold tracking-tight py-4 px-8 rounded-xl transition shadow-lg hover:shadow-xl flex items-center justify-center gap-3 group">
                                <span>Envoyer le message</span>
                                <svg class="w-6 h-6 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/>
                                </svg>
                            </button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Contact Info Column (40% - 2 cols) -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Address Card -->
                <div class="bg-white rounded-2xl shadow-lg border-2 border-slate-100 p-6">
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center">
                            <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-slate-900 mb-2 font-serif tracking-tight leading-tight">Notre adresse</h3>
                            <p class="text-slate-600 leading-relaxed">
                                Douala, Cameroun<br>
                                Akwa — Ngodi<br>
                                Derrière le cimetière, Immeuble MAD
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Phone Card -->
                <div class="bg-white rounded-2xl shadow-lg border-2 border-slate-100 p-6">
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-14 h-14 bg-green-100 rounded-xl flex items-center justify-center">
                            <svg class="w-7 h-7 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-slate-900 mb-2 font-serif tracking-tight leading-tight">Téléphone</h3>
                            <div class="space-y-1">
                                <a href="tel:+237600000000" class="block text-slate-600 hover:text-primary-600 transition">
                                    +237 233 47 03 27
                                </a>
                                <a href="tel:+237200000000" class="block text-slate-600 hover:text-primary-600 transition">
                                    +237 673 75 98 28
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Email Card -->
                <div class="bg-white rounded-2xl shadow-lg border-2 border-slate-100 p-6">
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-14 h-14 bg-purple-100 rounded-xl flex items-center justify-center">
                            <svg class="w-7 h-7 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold text-slate-900 mb-2 font-serif tracking-tight leading-tight">Email</h3>
                            <div class="space-y-1">
                                <a href="mailto:info@madacademy.xx" class="block text-slate-600 hover:text-primary-600 transition">
                                    info@madacademy.cm
                                </a>
                                <a href="mailto:inscription@madacademy.xx" class="block text-slate-600 hover:text-primary-600 transition">
                                    inscriptions@madacademy.cm
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Hours Card -->
                <div class="bg-gradient-to-br from-primary-900 via-primary-800 to-primary-900 rounded-2xl shadow-lg p-6 text-white">
                    <div class="flex items-start gap-4">
                        <div class="flex-shrink-0 w-14 h-14 bg-white/10 rounded-xl flex items-center justify-center">
                            <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-lg font-bold mb-3 font-serif tracking-tight leading-tight">Horaires d'ouverture</h3>
                            <div class="space-y-2 text-primary-100">
                                <div class="flex justify-between">
                                    <span>Lundi - Vendredi</span>
                                    <span class="font-semibold">8h00 - 17h00</span>
                                </div>
                                <div class="flex justify-between">
                                    <span>Samedi</span>
                                    <span class="font-semibold">8h00 - 12h00</span>
                                </div>
                                <div class="flex justify-between">
                                    <span>Dimanche</span>
                                    <span class="font-semibold">Fermé</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Social Media Card -->
                <div class="bg-white rounded-2xl shadow-lg border-2 border-slate-100 p-6">
                    <h3 class="text-lg font-bold text-slate-900 mb-4 font-serif tracking-tight leading-tight">Suivez-nous</h3>
                    <div class="flex gap-3">
                        <a href="https://facebook.com/madacademy" target="_blank" rel="noopener"
                           class="flex-1 flex items-center justify-center p-3 bg-blue-600 hover:bg-blue-700 text-white rounded-xl transition">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                            </svg>
                        </a>
                        <a href="https://instagram.com/madacademy" target="_blank" rel="noopener"
                           class="flex-1 flex items-center justify-center p-3 bg-pink-600 hover:bg-pink-700 text-white rounded-xl transition">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                            </svg>
                        </a>
                        <a href="https://linkedin.com/company/madacademy" target="_blank" rel="noopener"
                           class="flex-1 flex items-center justify-center p-3 bg-blue-700 hover:bg-blue-800 text-white rounded-xl transition">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Map Section -->
<section class="py-20 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <div class="inline-block px-4 py-2 bg-primary-50 text-primary-700 text-sm font-semibold rounded-full mb-4">
                Localisation
            </div>
            <h2 class="text-3xl sm:text-4xl font-bold text-slate-900 mb-4 font-serif tracking-tight leading-tight">
                Comment nous trouver
            </h2>
            <p class="text-lg text-slate-600 max-w-2xl mx-auto">
                Passez nous voir pour découvrir nos infrastructures et échanger avec notre équipe.
            </p>
        </div>

        <div class="bg-slate-200 rounded-2xl overflow-hidden shadow-lg" style="height: 450px;">
            <!-- Placeholder pour Google Maps -->
            <div class="w-full h-full flex items-center justify-center">
                <div class="text-center p-8">
                    <div class="w-20 h-20 bg-slate-300 rounded-full flex items-center justify-center mx-auto mb-6">
                        <svg class="w-10 h-10 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                        </svg>
                    </div>
                    <p class="text-xl text-slate-600 font-semibold mb-2">Carte Google Maps</p>
                    <p class="text-slate-500">Intégrer ici l’iframe Google Maps de Mad Academy</p>
                </div>
            </div>
            <!--
            Exemple d'intégration Google Maps:
            <iframe
                src="https://www.google.com/maps/embed?pb=..."
                width="100%"
                height="450"
                style="border:0;"
                allowfullscreen=""
                loading="lazy"
                referrerpolicy="no-referrer-when-downgrade">
            </iframe>
            -->
        </div>
    </div>
</section>

<!-- FAQ Section -->
@if(isset($faqs) && $faqs->count() > 0)
    <x-faq-accordion :faqs="$faqs" />
@endif

@endsection
