@extends('layouts.front')

@section('content')

<!-- Page Hero -->
<x-page-hero
    title="À propos de Mad Academy"
    subtitle="Un centre de formation professionnelle : pratique, rigueur, accompagnement — au service de votre insertion."
    :breadcrumb="true" />

<!-- Qui sommes-nous -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid lg:grid-cols-2 gap-16 items-center">
            <!-- Content -->
            <div>
                <div class="inline-block px-4 py-2 bg-primary-50 text-primary-700 text-sm font-semibold rounded-full mb-6">
                    Présentation
                </div>
                <h2 class="text-3xl sm:text-4xl font-bold text-slate-900 mb-6 font-serif tracking-tight leading-tight">
                    Qui sommes-nous ?
                </h2>
                <div class="prose prose-lg text-slate-600">
                    <p class="mb-4">
                        <strong>Mad Academy</strong> est un centre de formation professionnelle qui prépare aux métiers, avec une pédagogie structurée et orientée compétences.
                    </p>
                    <p class="mb-4">
                        Notre objectif est simple : rendre nos apprenants opérationnels. Chaque parcours est conçu pour développer des savoir-faire concrets, recherchés par les entreprises.
                    </p>
                    <p>
                        Nous combinons apprentissages essentiels, pratique encadrée, ateliers et mises en situation, afin de renforcer l’employabilité et la confiance professionnelle.
                    </p>
                </div>

            </div>

            <!-- Image -->
            <div class="relative">
                <div class="aspect-[4/3] rounded-2xl overflow-hidden shadow-2xl">
                    <img src="{{ asset('images/mad-academy-apropos.jpg') }}"
                         alt="Mad Academy — formation professionnelle"
                         class="w-full h-full object-cover"
                         onerror="this.parentElement.innerHTML='<div class=\'w-full h-full bg-gradient-to-br from-primary-100 to-primary-200 flex items-center justify-center\'><svg class=\'w-20 h-20 text-primary-400\' fill=\'none\' stroke=\'currentColor\' viewBox=\'0 0 24 24\'><path stroke-linecap=\'round\' stroke-linejoin=\'round\' stroke-width=\'2\' d=\'M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4\'/></svg></div>'">
                </div>
                <!-- Decoration -->
                <div class="absolute -bottom-6 -right-6 w-72 h-72 bg-primary-100 rounded-full -z-10 blur-3xl opacity-50"></div>
            </div>
        </div>
    </div>
</section>

<!-- Mission & Vision -->
<section class="py-20 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="text-center mb-16">
            <div class="inline-block px-4 py-2 bg-primary-50 text-primary-700 text-sm font-semibold rounded-full mb-4">
                Ce qui nous guide
            </div>
            <h2 class="text-3xl sm:text-4xl font-bold text-slate-900 mb-4 font-serif tracking-tight leading-tight">
                Notre mission et notre vision
            </h2>
            <p class="text-xl text-slate-600 max-w-2xl mx-auto">
                Former utile, former bien, former pour réussir — avec une exigence constante.
            </p>
        </div>

        <!-- Cards -->
        <div class="grid md:grid-cols-2 gap-8 max-w-5xl mx-auto">
            <!-- Mission -->
            <div class="bg-white rounded-2xl p-8 md:p-10 shadow-lg border-t-4 border-primary-600 hover:shadow-xl transition">
                <div class="w-16 h-16 bg-primary-100 rounded-2xl flex items-center justify-center mb-6">
                    <svg class="w-8 h-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-slate-900 mb-4 font-serif tracking-tight leading-tight">Notre mission</h3>
                <p class="text-slate-600 leading-relaxed text-lg">
                    Former des professionnels compétents et immédiatement opérationnels, grâce à une pédagogie pratique, un encadrement rigoureux et des outils adaptés aux réalités du terrain.
                </p>
            </div>

            <!-- Vision -->
            <div class="bg-white rounded-2xl p-8 md:p-10 shadow-lg border-t-4 border-green-600 hover:shadow-xl transition">
                <div class="w-16 h-16 bg-green-100 rounded-2xl flex items-center justify-center mb-6">
                    <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                    </svg>
                </div>
                <h3 class="text-2xl font-bold text-slate-900 mb-4 font-serif tracking-tight leading-tight">Notre vision</h3>
                <p class="text-slate-600 leading-relaxed text-lg">
                    Être une référence de la formation professionnelle au Cameroun, reconnue pour la qualité de ses parcours, sa rigueur, et l’insertion durable de ses apprenants — dans le respect de standards de travail exigeants.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Nos Valeurs Fondamentales -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="text-center mb-16">
            <div class="inline-block px-4 py-2 bg-primary-50 text-primary-700 text-sm font-semibold rounded-full mb-4">
                Nos valeurs
            </div>
            <h2 class="text-3xl sm:text-4xl font-bold text-slate-900 mb-4 font-serif tracking-tight leading-tight">
                Nos principes de formation
            </h2>
            <p class="text-xl text-slate-600 max-w-2xl mx-auto">
                Des repères clairs qui structurent notre pédagogie et notre accompagnement.
            </p>
        </div>

        <div class="grid lg:grid-cols-2 gap-16 items-center">
            <!-- Video à gauche -->
            <div class="relative order-2 lg:order-1">
                <div class="relative rounded-2xl overflow-hidden shadow-2xl bg-slate-900">
                    <video
                        class="w-full aspect-video object-cover"
                        autoplay
                        muted
                        loop
                        playsinline
                        poster="{{ asset('images/mad-academy-video-poster.jpg') }}"
                    >
                        <source src="{{ asset('videos/mad-academy-valeurs.mp4') }}" type="video/mp4">
                        <!-- Fallback -->
                        <div class="w-full aspect-video bg-slate-800 flex items-center justify-center">
                            <div class="text-center text-slate-400 p-8">
                                <svg class="w-20 h-20 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                </svg>
                                <p class="text-lg">Vidéo de présentation Mad Academy</p>
                            </div>
                        </div>
                    </video>
                </div>
                <!-- Decoration -->
                <div class="absolute -top-6 -left-6 w-72 h-72 bg-primary-100 rounded-full -z-10 blur-3xl opacity-50"></div>
            </div>

            <!-- Valeurs en grille 2x2 à droite -->
            <div class="order-1 lg:order-2">
                <div class="grid grid-cols-2 gap-6">
                    <!-- Excellence -->
                    <div class="bg-slate-50 rounded-xl p-6 border-2 border-transparent hover:border-primary-200 transition">
                        <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2 font-serif tracking-tight leading-tight">Excellence</h3>
                        <p class="text-slate-600 text-sm leading-relaxed">
                            Viser des standards élevés : contenu, pratique, discipline et qualité d’exécution.
                        </p>
                    </div>

                    <!-- Intégrité -->
                    <div class="bg-slate-50 rounded-xl p-6 border-2 border-transparent hover:border-primary-200 transition">
                        <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2 font-serif tracking-tight leading-tight">Intégrité</h3>
                        <p class="text-slate-600 text-sm leading-relaxed">
                            Agir avec honnêteté, responsabilité et respect des engagements.
                        </p>
                    </div>

                    <!-- Innovation -->
                    <div class="bg-slate-50 rounded-xl p-6 border-2 border-transparent hover:border-primary-200 transition">
                        <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2 font-serif tracking-tight leading-tight">Innovation</h3>
                        <p class="text-slate-600 text-sm leading-relaxed">
                            Actualiser les méthodes, intégrer les bons outils et évoluer avec les métiers.
                        </p>
                    </div>

                    <!-- Engagement -->
                    <div class="bg-slate-50 rounded-xl p-6 border-2 border-transparent hover:border-primary-200 transition">
                        <div class="w-14 h-14 bg-primary-100 rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-7 h-7 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-slate-900 mb-2 font-serif tracking-tight leading-tight">Accompagnement</h3>
                        <p class="text-slate-600 text-sm leading-relaxed">
                            Orienter, suivre et soutenir chaque apprenant vers l’objectif professionnel.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Final -->
<x-cta-banner
    title="Construisons votre projet professionnel"
    subtitle="Découvrez nos formations orientées métiers et choisissez une filière adaptée à vos objectifs. Nous vous conseillons et vous accompagnons à chaque étape."
    ctaText="Voir nos formations"
    ctaUrl="{{ route('programmes') }}" />

@endsection
