@props(['testimonials' => []])

<!-- Section Témoignages avec Carousel Alpine.js -->
<section class="py-20 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

        <!-- Header -->
        <div class="text-center mb-16">
            <h2 class="text-3xl sm:text-4xl font-bold text-slate-900 mb-4 font-serif tracking-tight leading-tight">
                Témoignages
            </h2>
            <p class="text-xl text-slate-600 max-w-2xl mx-auto">
                Des retours d’apprenants sur la qualité de la formation et l’accompagnement.
            </p>
        </div>

        <!-- Carousel -->
        <div x-data="{
            activeSlide: 0,
            slides: {{ count($testimonials) > 0 ? count($testimonials) : 3 }},
            autoplay: null,
            init() {
                this.autoplay = setInterval(() => {
                    this.next();
                }, 5000);
            },
            next() {
                this.activeSlide = (this.activeSlide + 1) % this.slides;
            },
            prev() {
                this.activeSlide = (this.activeSlide - 1 + this.slides) % this.slides;
            }
        }"
        @mouseenter="clearInterval(autoplay)"
        @mouseleave="autoplay = setInterval(() => { next(); }, 5000)"
        class="relative">

            <!-- Slides Container -->
            <div class="overflow-hidden">
                <div class="flex transition-transform duration-500 ease-out"
                     :style="'transform: translateX(-' + (activeSlide * 100) + '%)'">

                    @forelse($testimonials as $testimonial)
                        <!-- Slide -->
                        <div class="w-full flex-shrink-0 px-4">
                            <div class="bg-white rounded-2xl shadow-xl p-8 md:p-12 max-w-4xl mx-auto">

                                <!-- Quote Icon -->
                                <div class="flex justify-center mb-6">
                                    <svg class="w-12 h-12 text-primary-200" fill="currentColor" viewBox="0 0 24 24">
                                        <path d="M14.017 21v-7.391c0-5.704 3.731-9.57 8.983-10.609l.995 2.151c-2.432.917-3.995 3.638-3.995 5.849h4v10h-9.983zm-14.017 0v-7.391c0-5.704 3.748-9.57 9-10.609l.996 2.151c-2.433.917-3.996 3.638-3.996 5.849h3.983v10h-9.983z"/>
                                    </svg>
                                </div>

                                <!-- Testimonial Text -->
                                <blockquote class="text-lg md:text-xl text-slate-700 text-center mb-8 leading-relaxed">
                                    "{{ $testimonial['text'] }}"
                                </blockquote>

                                <!-- Author -->
                                <div class="flex items-center justify-center gap-4">
                                    <div class="w-16 h-16 rounded-full bg-gradient-to-br from-primary-400 to-primary-600 flex items-center justify-center text-white text-xl font-bold">
                                        {{ substr($testimonial['name'], 0, 1) }}
                                    </div>
                                    <div class="text-left">
                                        <div class="font-bold text-slate-900">{{ $testimonial['name'] }}</div>
                                        <div class="text-sm text-slate-600">{{ $testimonial['programme'] }}</div>
                                        @if(isset($testimonial['promotion']))
                                            <div class="text-xs text-slate-500">Promotion {{ $testimonial['promotion'] }}</div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <!-- Placeholder Slides -->
                        @foreach([
                            ['name' => 'Ange N.', 'programme' => 'Infographie / Design', 'text' => 'Une formation très pratique, avec un bon encadrement. J’ai progressé rapidement et gagné en assurance.'],
                            ['name' => 'Patrick M.', 'programme' => 'Comptabilité informatisée', 'text' => 'Les cours sont structurés et orientés métier. Le suivi m’a vraiment aidé à rester régulier.'],
                            ['name' => 'Sandrine K.', 'programme' => 'Maintenance informatique', 'text' => 'Des enseignants disponibles, des exercices concrets et une ambiance sérieuse. Je recommande.']
                        ] as $placeholder)
                            <div class="w-full flex-shrink-0 px-4">
                                <div class="bg-white rounded-2xl shadow-xl p-8 md:p-12 max-w-4xl mx-auto">
                                    <div class="flex justify-center mb-6">
                                        <svg class="w-12 h-12 text-primary-200" fill="currentColor" viewBox="0 0 24 24">
                                            <path d="M14.017 21v-7.391c0-5.704 3.731-9.57 8.983-10.609l.995 2.151c-2.432.917-3.995 3.638-3.995 5.849h4v10h-9.983zm-14.017 0v-7.391c0-5.704 3.748-9.57 9-10.609l.996 2.151c-2.433.917-3.996 3.638-3.996 5.849h3.983v10h-9.983z"/>
                                        </svg>
                                    </div>
                                    <blockquote class="text-lg md:text-xl text-slate-700 text-center mb-8 leading-relaxed">
                                        "{{ $placeholder['text'] }}"
                                    </blockquote>
                                    <div class="flex items-center justify-center gap-4">
                                        <div class="w-16 h-16 rounded-full bg-gradient-to-br from-primary-400 to-primary-600 flex items-center justify-center text-white text-xl font-bold">
                                            {{ substr($placeholder['name'], 0, 1) }}
                                        </div>
                                        <div class="text-left">
                                            <div class="font-bold text-slate-900">{{ $placeholder['name'] }}</div>
                                            <div class="text-sm text-slate-600">{{ $placeholder['programme'] }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endforelse

                </div>
            </div>

            <!-- Navigation Arrows -->
            <button @click="prev()"
                    class="absolute left-0 top-1/2 -translate-y-1/2 -translate-x-4 w-12 h-12 bg-white rounded-full shadow-lg flex items-center justify-center hover:bg-slate-50 transition">
                <svg class="w-6 h-6 text-slate-700" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                </svg>
            </button>
            <button @click="next()"
                    class="absolute right-0 top-1/2 -translate-y-1/2 translate-x-4 w-12 h-12 bg-white rounded-full shadow-lg flex items-center justify-center hover:bg-slate-50 transition">
                <svg class="w-6 h-6 text-slate-700" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                </svg>
            </button>

            <!-- Dots Indicators -->
            <div class="flex justify-center gap-2 mt-8">
                <template x-for="(slide, index) in slides" :key="index">
                    <button @click="activeSlide = index"
                            :class="activeSlide === index ? 'bg-primary-600 w-8' : 'bg-slate-300 w-2'"
                            class="h-2 rounded-full transition-all duration-300"></button>
                </template>
            </div>

        </div>
    </div>
</section>
