@props(['steps', 'currentStep' => 1])

<!-- Stepper Horizontal pour Processus d'Inscription -->
<div class="py-8">
    <div class="max-w-4xl mx-auto px-4">
        <div class="flex items-center justify-between">
            @foreach($steps as $index => $step)
                @php
                    $stepNumber = $index + 1;
                    $isCompleted = $stepNumber < $currentStep;
                    $isCurrent = $stepNumber === $currentStep;
                    $isPending = $stepNumber > $currentStep;
                @endphp

                <!-- Step Item -->
                <div class="flex-1 relative">
                    <div class="flex flex-col items-center">

                        <!-- Circle -->
                        <div class="relative z-10 flex items-center justify-center w-12 h-12 rounded-full border-4 transition-all duration-300
                            @if($isCompleted) bg-primary-600 border-primary-600
                            @elseif($isCurrent) bg-white border-primary-600
                            @else bg-white border-slate-300
                            @endif">

                            @if($isCompleted)
                                <!-- Checkmark -->
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M5 13l4 4L19 7"/>
                                </svg>
                            @else
                                <!-- Step Number -->
                                <span class="text-lg font-bold
                                    @if($isCurrent) text-primary-600
                                    @else text-slate-400
                                    @endif">
                                    {{ $stepNumber }}
                                </span>
                            @endif
                        </div>

                        <!-- Label -->
                        <div class="mt-3 text-center">
                            <div class="text-sm font-semibold
                                @if($isCompleted || $isCurrent) text-slate-900
                                @else text-slate-400
                                @endif">
                                {{ $step['label'] }}
                            </div>
                            @if(isset($step['description']))
                                <div class="text-xs text-slate-500 mt-1 hidden sm:block">
                                    {{ $step['description'] }}
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- Connector Line -->
                    @if(!$loop->last)
                        <div class="absolute top-6 left-1/2 w-full h-1 -z-10 transition-all duration-300
                            @if($isCompleted) bg-primary-600
                            @else bg-slate-300
                            @endif">
                        </div>
                    @endif
                </div>
            @endforeach
        </div>
    </div>
</div>
