@props(['programmes', 'showFilters' => false])

<!-- Programmes Grid avec Filtres Optionnels -->
<section class="py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

        @if($showFilters)
            <!-- Filtres (Alpine.js) -->
            <div class="mb-12" x-data="{ activeFilter: 'tous' }">
                <div class="flex flex-wrap gap-3 justify-center">
                    <button @click="activeFilter = 'tous'"
                            :class="activeFilter === 'tous' ? 'bg-primary-600 text-white' : 'bg-white text-slate-700 hover:bg-slate-50'"
                            class="px-6 py-2 rounded-full font-medium transition shadow-sm">
                        Toutes les filières
                    </button>
                    <button @click="activeFilter = 'Bac+2'"
                            :class="activeFilter === 'Bac+2' ? 'bg-primary-600 text-white' : 'bg-white text-slate-700 hover:bg-slate-50'"
                            class="px-6 py-2 rounded-full font-medium transition shadow-sm">
                        Imprimerie
                    </button>
                    <button @click="activeFilter = 'Bac+3'"
                            :class="activeFilter === 'Bac+3' ? 'bg-primary-600 text-white' : 'bg-white text-slate-700 hover:bg-slate-50'"
                            class="px-6 py-2 rounded-full font-medium transition shadow-sm">
                        Informatique
                    </button>
                    <button @click="activeFilter = 'Bac+5'"
                            :class="activeFilter === 'Bac+5' ? 'bg-primary-600 text-white' : 'bg-white text-slate-700 hover:bg-slate-50'"
                            class="px-6 py-2 rounded-full font-medium transition shadow-sm">
                        Gestion & Numérique
                    </button>
                </div>
            </div>
        @endif

        <!-- Grid des programmes -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @forelse($programmes as $programme)
                <x-programme-card :programme="$programme" />
            @empty
                <div class="col-span-full text-center py-16">
                    <svg class="w-20 h-20 mx-auto text-slate-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                    </svg>
                    <p class="text-xl text-slate-500 font-medium">Aucune formation disponible pour le moment</p>
                </div>
            @endforelse
        </div>
    </div>
</section>
