@props(['title', 'subtitle', 'ctaPrimary' => null, 'ctaSecondary' => null, 'image' => 'hero-accueil.jpg', 'height' => '75vh'])

<!-- Hero Premium -->
<section class="relative bg-white overflow-hidden flex items-center" style="height: {{ $height }}; min-height: 520px; max-height: 720px;">
    <!-- Background Video avec Overlay clair -->
    <div class="absolute inset-0 z-0 pointer-events-none">
        <video class="absolute inset-0 w-full h-full object-cover" autoplay muted loop playsinline preload="metadata" poster="{{ asset('images/' . $image) }}">
            <source src="{{ asset('assets/hero/mad-hero.mp4') }}" type="video/mp4">
            Votre navigateur ne prend pas en charge la lecture de vidéos.
        </video>
        <!-- Overlay premium pour lisibilite -->
        <div class="absolute inset-0 bg-black/12"></div>
        <div class="absolute inset-0 bg-gradient-to-r from-black/60 via-black/30 to-transparent"></div>
        <div class="absolute inset-0 bg-[radial-gradient(ellipse_at_top_right,rgba(2,132,199,0.22),transparent_55%)]"></div>
        <div class="absolute inset-0 bg-[radial-gradient(ellipse_at_bottom_left,rgba(220,38,38,0.18),transparent_60%)]"></div>
    </div>

    <!-- Content -->
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 w-full">
        <div class="max-w-2xl">
            <!-- Badge optionnel -->
            {{ $badge ?? '' }}

            <!-- Title -->
            <h1 class="text-4xl sm:text-5xl lg:text-6xl font-bold text-white mt-4 leading-tight tracking-tight font-serif">
                {{ $title }}
            </h1>

            <!-- Subtitle - meilleur contraste -->
            <p class="text-lg sm:text-xl text-white mt-3 leading-relaxed max-w-xl">
                {{ $subtitle }}
            </p>

            <!-- CTAs -->
            <div class="mt-6 flex flex-col sm:flex-row gap-4">
                @if($ctaPrimary)
                    <a href="{{ $ctaPrimary['url'] }}"
                       class="inline-flex items-center justify-center px-7 py-3 bg-red-600 hover:bg-red-700 text-white text-base font-semibold tracking-tight rounded-xl transition shadow-sm hover:shadow-md ring-1 ring-red-500/30 focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-sky-400 focus-visible:ring-offset-2 group">
                        {{ $ctaPrimary['text'] }}
                        <svg class="w-5 h-5 ml-2 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"/>
                        </svg>
                    </a>
                @endif
                @if($ctaSecondary)
                    <a href="{{ $ctaSecondary['url'] }}"
                       class="inline-flex items-center justify-center px-7 py-3 bg-sky-600 hover:bg-sky-700 text-white text-base font-semibold tracking-tight rounded-xl transition shadow-sm hover:shadow-md focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-sky-300 focus-visible:ring-offset-2">
                        {{ $ctaSecondary['text'] }}
                    </a>
                @endif
            </div>
        </div>
    </div>
</section>
