@extends('layouts.admin')

@section('page-title', 'Nouvelle statistique')

@section('content')
<div class="max-w-2xl">
    <!-- En-tête avec retour -->
    <div class="flex items-center gap-4 mb-6">
        <a href="{{ route('admin.statistics.index') }}" class="inline-flex items-center px-3 py-1.5 text-sm font-medium text-slate-600 hover:text-slate-900 bg-white hover:bg-slate-50 rounded-lg border border-slate-200 transition">
            <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
            Retour
        </a>
    </div>

    <div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
        <!-- En-tête Premium -->
        <div class="px-6 py-5 border-b border-slate-100 bg-gradient-to-r from-purple-50 to-white">
            <div class="flex items-center gap-4">
                <div class="w-12 h-12 bg-gradient-to-br from-purple-400 to-purple-600 rounded-xl flex items-center justify-center shadow-lg shadow-purple-200">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                    </svg>
                </div>
                <div>
                    <h1 class="text-lg font-bold text-slate-800">Ajouter une statistique</h1>
                    <p class="text-sm text-slate-500">Ce chiffre cle sera affiche sur le site</p>
                </div>
            </div>
        </div>

        <!-- Formulaire -->
        <form action="{{ route('admin.statistics.store') }}" method="POST" class="p-6">
            @csrf

            <div class="space-y-6">
                <!-- Libellé -->
                <div>
                    <label for="libelle" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                        <span class="w-6 h-6 bg-purple-100 rounded-md flex items-center justify-center mr-2">
                            <svg class="w-3.5 h-3.5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                            </svg>
                        </span>
                        Libelle
                    </label>
                    <input type="text" name="libelle" id="libelle" value="{{ old('libelle') }}"
                           class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-purple-500/20 focus:border-purple-500 transition @error('libelle') border-red-400 ring-2 ring-red-100 @enderror"
                           placeholder="Ex: Taux de reussite">
                    @error('libelle')
                        <p class="mt-2 text-sm text-red-600 flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Valeur -->
                <div>
                    <label for="valeur" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                        <span class="w-6 h-6 bg-red-100 rounded-md flex items-center justify-center mr-2">
                            <svg class="w-3.5 h-3.5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                            </svg>
                        </span>
                        Valeur
                    </label>
                    <input type="text" name="valeur" id="valeur" value="{{ old('valeur') }}"
                           class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-purple-500/20 focus:border-purple-500 transition @error('valeur') border-red-400 ring-2 ring-red-100 @enderror"
                           placeholder="Ex: 95%">
                    @error('valeur')
                        <p class="mt-2 text-sm text-red-600 flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Icône -->
                <div>
                    <label for="icone" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                        <span class="w-6 h-6 bg-sky-100 rounded-md flex items-center justify-center mr-2">
                            <svg class="w-3.5 h-3.5 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                        </span>
                        Icone
                    </label>
                    <select name="icone" id="icone"
                            class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 bg-white focus:outline-none focus:ring-2 focus:ring-purple-500/20 focus:border-purple-500 transition">
                        <option value="chart" {{ old('icone') == 'chart' ? 'selected' : '' }}>Graphique (Taux/Pourcentage)</option>
                        <option value="briefcase" {{ old('icone') == 'briefcase' ? 'selected' : '' }}>Mallette (Entreprises)</option>
                        <option value="users" {{ old('icone') == 'users' ? 'selected' : '' }}>Utilisateurs (Etudiants)</option>
                        <option value="academic" {{ old('icone') == 'academic' ? 'selected' : '' }}>Academique (Diplomes)</option>
                        <option value="clock" {{ old('icone') == 'clock' ? 'selected' : '' }}>Horloge (Annees)</option>
                        <option value="star" {{ old('icone') == 'star' ? 'selected' : '' }}>Etoile (Excellence)</option>
                    </select>
                    @error('icone')
                        <p class="mt-2 text-sm text-red-600 flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Ordre -->
                <div>
                    <label for="ordre" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                        <span class="w-6 h-6 bg-slate-100 rounded-md flex items-center justify-center mr-2">
                            <svg class="w-3.5 h-3.5 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4"/>
                            </svg>
                        </span>
                        Ordre d'affichage
                    </label>
                    <input type="number" name="ordre" id="ordre" value="{{ old('ordre', 0) }}" min="0"
                           class="w-32 px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition @error('ordre') border-red-400 ring-2 ring-red-100 @enderror">
                    <p class="mt-2 text-xs text-slate-500">Les statistiques sont triees par ordre croissant</p>
                    @error('ordre')
                        <p class="mt-2 text-sm text-red-600 flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Statut -->
                <div class="bg-gradient-to-r from-slate-50 to-white rounded-xl p-5 border border-slate-100">
                    <label class="relative flex items-start gap-4 cursor-pointer">
                        <input type="hidden" name="actif" value="0">
                        <div class="relative">
                            <input type="checkbox" name="actif" value="1" {{ old('actif', true) ? 'checked' : '' }}
                                   class="sr-only peer">
                            <div class="w-11 h-6 bg-slate-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-purple-500/20 rounded-full peer peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-slate-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-gradient-to-r peer-checked:from-emerald-400 peer-checked:to-emerald-500"></div>
                        </div>
                        <div>
                            <span class="text-sm font-bold text-slate-800">Statistique active</span>
                            <p class="text-sm text-slate-500 mt-0.5">La statistique sera visible sur le site</p>
                        </div>
                    </label>
                </div>
            </div>

            <!-- Actions -->
            <div class="flex items-center justify-between pt-6 mt-6 border-t border-slate-100">
                <a href="{{ route('admin.statistics.index') }}" class="text-sm font-medium text-slate-500 hover:text-slate-700 transition">
                    Annuler
                </a>
                <button type="submit" class="inline-flex items-center px-5 py-2.5 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white text-sm font-bold rounded-xl transition shadow-lg shadow-red-200">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    Creer la statistique
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
