@extends('layouts.admin')

@section('page-title', 'Configuration email')

@section('content')
<div class="max-w-2xl">
    <div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
        <!-- En-tête Premium -->
        <div class="px-6 py-5 border-b border-slate-100 bg-gradient-to-r from-sky-50 to-white">
            <div class="flex items-center gap-4">
                <div class="w-12 h-12 bg-gradient-to-br from-sky-400 to-sky-600 rounded-xl flex items-center justify-center shadow-lg shadow-sky-200">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"/>
                    </svg>
                </div>
                <div>
                    <h1 class="text-lg font-bold text-slate-800">Configuration email</h1>
                    <p class="text-sm text-slate-500">Parametres du serveur SMTP pour l'envoi d'emails</p>
                </div>
            </div>
        </div>

        <!-- Formulaire -->
        <form method="POST" action="{{ route('admin.settings.email.update') }}" class="p-6">
            @csrf

            <div class="space-y-6">
                <!-- Activer l'envoi d'emails -->
                <div class="bg-gradient-to-r from-slate-50 to-white rounded-xl p-5 border border-slate-100">
                    <label class="relative flex items-start gap-4 cursor-pointer">
                        <input type="hidden" name="mail_enabled" value="0">
                        <div class="relative">
                            <input type="checkbox" name="mail_enabled" id="mail_enabled" value="1"
                                   {{ $settings->mail_enabled ? 'checked' : '' }}
                                   class="sr-only peer">
                            <div class="w-11 h-6 bg-slate-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-sky-500/20 rounded-full peer peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-slate-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-gradient-to-r peer-checked:from-emerald-400 peer-checked:to-emerald-500"></div>
                        </div>
                        <div>
                            <span class="text-sm font-bold text-slate-800">Activer l'envoi d'emails</span>
                            <p class="text-sm text-slate-500 mt-0.5">Si desactive, aucun email ne sera envoye depuis l'application (confirmations, reponses aux messages, etc.)</p>
                        </div>
                    </label>
                </div>

                <!-- Configuration SMTP -->
                <div class="space-y-4">
                    <h3 class="text-sm font-bold text-slate-800 flex items-center gap-3">
                        <span class="w-8 h-8 bg-gradient-to-br from-slate-500 to-slate-600 rounded-lg flex items-center justify-center shadow-sm">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 12h14M5 12a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v4a2 2 0 01-2 2M5 12a2 2 0 00-2 2v4a2 2 0 002 2h14a2 2 0 002-2v-4a2 2 0 00-2-2m-2-4h.01M17 16h.01"/>
                            </svg>
                        </span>
                        Configuration serveur
                    </h3>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="mail_mailer" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                                Type de mailer
                            </label>
                            <select name="mail_mailer" id="mail_mailer"
                                    class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 bg-white focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition">
                                <option value="smtp" {{ $settings->mail_mailer === 'smtp' ? 'selected' : '' }}>SMTP</option>
                                <option value="sendmail" {{ $settings->mail_mailer === 'sendmail' ? 'selected' : '' }}>Sendmail</option>
                                <option value="log" {{ $settings->mail_mailer === 'log' ? 'selected' : '' }}>Log (test)</option>
                            </select>
                        </div>

                        <div>
                            <label for="mail_encryption" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                                Chiffrement
                            </label>
                            <select name="mail_encryption" id="mail_encryption"
                                    class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 bg-white focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition">
                                <option value="tls" {{ $settings->mail_encryption === 'tls' ? 'selected' : '' }}>TLS</option>
                                <option value="ssl" {{ $settings->mail_encryption === 'ssl' ? 'selected' : '' }}>SSL</option>
                                <option value="null" {{ $settings->mail_encryption === 'null' || !$settings->mail_encryption ? 'selected' : '' }}>Aucun</option>
                            </select>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="mail_host" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                                Serveur SMTP
                            </label>
                            <input type="text" name="mail_host" id="mail_host" value="{{ $settings->mail_host }}"
                                   class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition"
                                   placeholder="smtp.example.com">
                        </div>

                        <div>
                            <label for="mail_port" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                                Port
                            </label>
                            <input type="text" name="mail_port" id="mail_port" value="{{ $settings->mail_port ?? '587' }}"
                                   class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition"
                                   placeholder="587">
                        </div>
                    </div>
                </div>

                <!-- Authentification -->
                <div class="space-y-4">
                    <h3 class="text-sm font-bold text-slate-800 flex items-center gap-3">
                        <span class="w-8 h-8 bg-gradient-to-br from-amber-400 to-amber-500 rounded-lg flex items-center justify-center shadow-sm">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"/>
                            </svg>
                        </span>
                        Authentification
                    </h3>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="mail_username" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                                Identifiant SMTP
                            </label>
                            <input type="text" name="mail_username" id="mail_username" value="{{ $settings->mail_username }}"
                                   class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition"
                                   placeholder="votre@email.com">
                        </div>

                        <div>
                            <label for="mail_password" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                                Mot de passe SMTP
                            </label>
                            <input type="password" name="mail_password" id="mail_password" value="{{ $settings->mail_password }}"
                                   class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition"
                                   placeholder="••••••••">
                        </div>
                    </div>
                </div>

                <!-- Expéditeur -->
                <div class="space-y-4">
                    <h3 class="text-sm font-bold text-slate-800 flex items-center gap-3">
                        <span class="w-8 h-8 bg-gradient-to-br from-emerald-400 to-emerald-500 rounded-lg flex items-center justify-center shadow-sm">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                        </span>
                        Expediteur par defaut
                    </h3>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label for="mail_from_address" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                                Email d'expedition
                            </label>
                            <input type="email" name="mail_from_address" id="mail_from_address" value="{{ $settings->mail_from_address }}"
                                   class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition"
                                   placeholder="contact@madacademy.xx">
                        </div>

                        <div>
                            <label for="mail_from_name" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                                Nom d'expediteur
                            </label>
                            <input type="text" name="mail_from_name" id="mail_from_name" value="{{ $settings->mail_from_name ?? 'Mad Academy' }}"
                                   class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition"
                                   placeholder="Mad Academy">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Actions -->
            <div class="pt-6 mt-6 border-t border-slate-100">
                <button type="submit" class="inline-flex items-center px-5 py-2.5 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white text-sm font-bold rounded-xl transition shadow-lg shadow-red-200">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    Enregistrer les modifications
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
