@extends('layouts.admin')

@section('page-title', 'Nouveau programme')

@section('content')
<div class="max-w-2xl">
    <!-- En-tête avec retour -->
    <div class="flex items-center gap-4 mb-6">
        <a href="{{ route('admin.programmes.index') }}" class="inline-flex items-center px-3 py-1.5 text-sm font-medium text-slate-600 hover:text-slate-900 bg-white hover:bg-slate-50 rounded-lg border border-slate-200 transition">
            <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
            Retour
        </a>
    </div>

    <div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
        <!-- En-tête Premium -->
        <div class="px-6 py-5 border-b border-slate-100 bg-gradient-to-r from-sky-50 to-white">
            <div class="flex items-center gap-4">
                <div class="w-12 h-12 bg-gradient-to-br from-sky-400 to-sky-600 rounded-xl flex items-center justify-center shadow-lg shadow-sky-200">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                    </svg>
                </div>
                <div>
                    <h1 class="text-lg font-bold text-slate-800">Ajouter un programme</h1>
                    <p class="text-sm text-slate-500">Creez une nouvelle formation BTS</p>
                </div>
            </div>
        </div>

        <!-- Formulaire -->
        <form action="{{ route('admin.programmes.store') }}" method="POST" class="p-6">
            @csrf

            <div class="space-y-6">
                <!-- Titre -->
                <div>
                    <label for="titre" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                        <span class="w-6 h-6 bg-sky-100 rounded-md flex items-center justify-center mr-2">
                            <svg class="w-3.5 h-3.5 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                            </svg>
                        </span>
                        Titre du programme
                    </label>
                    <input type="text" name="titre" id="titre" value="{{ old('titre') }}"
                           class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition @error('titre') border-red-400 ring-2 ring-red-100 @enderror"
                           placeholder="Ex: BTS Communication des Entreprises">
                    @error('titre')
                        <p class="mt-2 text-sm text-red-600 flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Description -->
                <div>
                    <label for="description" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                        <span class="w-6 h-6 bg-sky-100 rounded-md flex items-center justify-center mr-2">
                            <svg class="w-3.5 h-3.5 text-sky-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h7"/>
                            </svg>
                        </span>
                        Description
                    </label>
                    <textarea name="description" id="description" rows="5"
                              class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition resize-none @error('description') border-red-400 ring-2 ring-red-100 @enderror"
                              placeholder="Decrivez le programme, ses objectifs et debouches...">{{ old('description') }}</textarea>
                    @error('description')
                        <p class="mt-2 text-sm text-red-600 flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Pension -->
                <div>
                    <label for="pension" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                        <span class="w-6 h-6 bg-emerald-100 rounded-md flex items-center justify-center mr-2">
                            <svg class="w-3.5 h-3.5 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </span>
                        Pension annuelle
                    </label>
                    <div class="relative">
                        <input type="number" name="pension" id="pension" value="{{ old('pension') }}" step="1" min="0"
                               class="w-full px-4 py-3 pr-20 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition @error('pension') border-red-400 ring-2 ring-red-100 @enderror"
                               placeholder="0">
                        <span class="absolute right-4 top-1/2 -translate-y-1/2 text-sm font-medium text-slate-500 bg-slate-100 px-2 py-1 rounded">FCFA</span>
                    </div>
                    @error('pension')
                        <p class="mt-2 text-sm text-red-600 flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Statut -->
                <div class="bg-gradient-to-r from-slate-50 to-white rounded-xl p-5 border border-slate-100">
                    <label class="relative flex items-start gap-4 cursor-pointer">
                        <input type="hidden" name="statut" value="0">
                        <div class="relative">
                            <input type="checkbox" name="statut" value="1" {{ old('statut', true) ? 'checked' : '' }}
                                   class="sr-only peer">
                            <div class="w-11 h-6 bg-slate-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-sky-500/20 rounded-full peer peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-slate-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-gradient-to-r peer-checked:from-emerald-400 peer-checked:to-emerald-500"></div>
                        </div>
                        <div>
                            <span class="text-sm font-bold text-slate-800">Programme actif</span>
                            <p class="text-sm text-slate-500 mt-0.5">Le programme sera visible sur le site et disponible pour les inscriptions</p>
                        </div>
                    </label>
                </div>
            </div>

            <!-- Actions -->
            <div class="flex items-center justify-between pt-6 mt-6 border-t border-slate-100">
                <a href="{{ route('admin.programmes.index') }}" class="text-sm font-medium text-slate-500 hover:text-slate-700 transition">
                    Annuler
                </a>
                <button type="submit" class="inline-flex items-center px-5 py-2.5 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white text-sm font-bold rounded-xl transition shadow-lg shadow-red-200">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    Creer le programme
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
