@extends('layouts.admin')

@section('page-title', 'Detail inscription')

@section('content')
<div class="max-w-4xl">
    <!-- En-tête avec retour -->
    <div class="flex items-center gap-4 mb-6">
        <a href="{{ route('admin.inscriptions.index') }}" class="inline-flex items-center px-3 py-1.5 text-sm font-medium text-slate-600 hover:text-slate-900 bg-white hover:bg-slate-50 rounded-lg border border-slate-200 transition">
            <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
            Retour a la liste
        </a>
    </div>

    <!-- Carte principale -->
    <div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
        <!-- En-tête Premium -->
        <div class="px-6 py-5 border-b border-slate-100 bg-gradient-to-r from-red-50 to-white">
            <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
                <div class="flex items-center gap-4">
                    <div class="w-14 h-14 bg-gradient-to-br from-red-500 to-red-600 rounded-2xl flex items-center justify-center shadow-lg shadow-red-200 text-white text-xl font-bold">
                        {{ strtoupper(substr($inscription->prenom, 0, 1)) }}{{ strtoupper(substr($inscription->nom, 0, 1)) }}
                    </div>
                    <div>
                        <h1 class="text-xl font-bold text-slate-800">{{ $inscription->prenom }} {{ $inscription->nom }}</h1>
                        <p class="text-sm text-slate-500">Candidature du {{ $inscription->created_at->format('d/m/Y a H:i') }}</p>
                    </div>
                </div>
                @php
                    $statutConfig = [
                        'nouvelle' => ['label' => 'Nouvelle', 'bg' => 'bg-gradient-to-r from-sky-100 to-sky-50', 'text' => 'text-sky-700', 'dot' => 'bg-sky-500', 'border' => 'border-sky-200'],
                        'en_attente' => ['label' => 'En attente', 'bg' => 'bg-gradient-to-r from-amber-100 to-amber-50', 'text' => 'text-amber-700', 'dot' => 'bg-amber-500', 'border' => 'border-amber-200'],
                        'acceptee' => ['label' => 'Acceptee', 'bg' => 'bg-gradient-to-r from-emerald-100 to-emerald-50', 'text' => 'text-emerald-700', 'dot' => 'bg-emerald-500', 'border' => 'border-emerald-200'],
                        'refusee' => ['label' => 'Refusee', 'bg' => 'bg-gradient-to-r from-red-100 to-red-50', 'text' => 'text-red-700', 'dot' => 'bg-red-500', 'border' => 'border-red-200'],
                    ];
                    $config = $statutConfig[$inscription->statut] ?? ['label' => $inscription->statut, 'bg' => 'bg-slate-100', 'text' => 'text-slate-600', 'dot' => 'bg-slate-400', 'border' => 'border-slate-200'];
                @endphp
                <span class="inline-flex items-center px-4 py-2 text-sm font-bold rounded-xl {{ $config['bg'] }} {{ $config['text'] }} border {{ $config['border'] }}">
                    <span class="w-2 h-2 {{ $config['dot'] }} rounded-full mr-2 {{ $inscription->statut === 'nouvelle' ? 'animate-pulse' : '' }}"></span>
                    {{ $config['label'] }}
                </span>
            </div>
        </div>

        <!-- Contenu -->
        <div class="p-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Informations personnelles -->
                <div class="bg-gradient-to-br from-slate-50 to-white rounded-xl p-5 border border-slate-100">
                    <h2 class="text-sm font-bold text-slate-800 mb-4 flex items-center gap-3">
                        <span class="w-8 h-8 bg-gradient-to-br from-sky-400 to-sky-500 rounded-lg flex items-center justify-center shadow-sm">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                            </svg>
                        </span>
                        Informations personnelles
                    </h2>
                    <dl class="space-y-4">
                        <div class="flex items-start gap-3">
                            <span class="w-6 h-6 bg-slate-100 rounded flex items-center justify-center flex-shrink-0 mt-0.5">
                                <svg class="w-3.5 h-3.5 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                            </span>
                            <div>
                                <dt class="text-xs font-medium text-slate-500 uppercase tracking-wider">Nom complet</dt>
                                <dd class="mt-0.5 text-sm font-semibold text-slate-900">{{ $inscription->prenom }} {{ $inscription->nom }}</dd>
                            </div>
                        </div>
                        <div class="flex items-start gap-3">
                            <span class="w-6 h-6 bg-slate-100 rounded flex items-center justify-center flex-shrink-0 mt-0.5">
                                <svg class="w-3.5 h-3.5 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                </svg>
                            </span>
                            <div>
                                <dt class="text-xs font-medium text-slate-500 uppercase tracking-wider">Email</dt>
                                <dd class="mt-0.5 text-sm">
                                    <a href="mailto:{{ $inscription->email }}" class="text-sky-600 hover:text-sky-700 font-medium">{{ $inscription->email }}</a>
                                </dd>
                            </div>
                        </div>
                        <div class="flex items-start gap-3">
                            <span class="w-6 h-6 bg-slate-100 rounded flex items-center justify-center flex-shrink-0 mt-0.5">
                                <svg class="w-3.5 h-3.5 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                                </svg>
                            </span>
                            <div>
                                <dt class="text-xs font-medium text-slate-500 uppercase tracking-wider">Telephone</dt>
                                <dd class="mt-0.5 text-sm font-semibold text-slate-900">{{ $inscription->telephone }}</dd>
                            </div>
                        </div>
                    </dl>
                </div>

                <!-- Informations inscription -->
                <div class="bg-gradient-to-br from-slate-50 to-white rounded-xl p-5 border border-slate-100">
                    <h2 class="text-sm font-bold text-slate-800 mb-4 flex items-center gap-3">
                        <span class="w-8 h-8 bg-gradient-to-br from-red-400 to-red-500 rounded-lg flex items-center justify-center shadow-sm">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                            </svg>
                        </span>
                        Informations inscription
                    </h2>
                    <dl class="space-y-4">
                        <div class="flex items-start gap-3">
                            <span class="w-6 h-6 bg-slate-100 rounded flex items-center justify-center flex-shrink-0 mt-0.5">
                                <svg class="w-3.5 h-3.5 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                                </svg>
                            </span>
                            <div>
                                <dt class="text-xs font-medium text-slate-500 uppercase tracking-wider">Programme souhaite</dt>
                                <dd class="mt-0.5 text-sm font-bold text-red-600">{{ $inscription->programme->titre ?? 'N/A' }}</dd>
                            </div>
                        </div>
                        <div class="flex items-start gap-3">
                            <span class="w-6 h-6 bg-slate-100 rounded flex items-center justify-center flex-shrink-0 mt-0.5">
                                <svg class="w-3.5 h-3.5 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                </svg>
                            </span>
                            <div>
                                <dt class="text-xs font-medium text-slate-500 uppercase tracking-wider">Date d'inscription</dt>
                                <dd class="mt-0.5 text-sm font-semibold text-slate-900">{{ $inscription->created_at->format('d/m/Y a H:i') }}</dd>
                            </div>
                        </div>
                    </dl>
                </div>
            </div>

            @if($inscription->message)
                <!-- Message -->
                <div class="mt-6 bg-gradient-to-br from-amber-50 to-white rounded-xl p-5 border border-amber-100">
                    <h2 class="text-sm font-bold text-slate-800 mb-3 flex items-center gap-3">
                        <span class="w-8 h-8 bg-gradient-to-br from-amber-400 to-amber-500 rounded-lg flex items-center justify-center shadow-sm">
                            <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"/>
                            </svg>
                        </span>
                        Message du candidat
                    </h2>
                    <div class="bg-white rounded-lg p-4 border border-amber-100">
                        <p class="text-sm text-slate-700 whitespace-pre-wrap leading-relaxed">{{ $inscription->message }}</p>
                    </div>
                </div>
            @endif

            <!-- Changer le statut -->
            <div class="mt-6 bg-gradient-to-br from-slate-50 to-white rounded-xl p-5 border border-slate-100">
                <h2 class="text-sm font-bold text-slate-800 mb-4 flex items-center gap-3">
                    <span class="w-8 h-8 bg-gradient-to-br from-slate-500 to-slate-600 rounded-lg flex items-center justify-center shadow-sm">
                        <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                        </svg>
                    </span>
                    Changer le statut
                </h2>
                <form action="{{ route('admin.inscriptions.updateStatut', $inscription) }}" method="POST" class="flex flex-col sm:flex-row sm:items-center gap-3">
                    @csrf
                    @method('PATCH')
                    <select name="statut"
                            class="px-4 py-2.5 border border-slate-200 rounded-xl text-slate-900 bg-white focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition font-medium">
                        <option value="nouvelle" {{ $inscription->statut === 'nouvelle' ? 'selected' : '' }}>Nouvelle</option>
                        <option value="en_attente" {{ $inscription->statut === 'en_attente' ? 'selected' : '' }}>En attente</option>
                        <option value="acceptee" {{ $inscription->statut === 'acceptee' ? 'selected' : '' }}>Acceptee</option>
                        <option value="refusee" {{ $inscription->statut === 'refusee' ? 'selected' : '' }}>Refusee</option>
                    </select>
                    <button type="submit" class="inline-flex items-center px-5 py-2.5 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white text-sm font-bold rounded-xl transition shadow-lg shadow-red-200">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                        </svg>
                        Mettre a jour
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
