@extends('layouts.admin')

@section('page-title', 'Modifier FAQ')

@section('content')
<div class="max-w-2xl">
    <!-- En-tête avec retour -->
    <div class="flex items-center gap-4 mb-6">
        <a href="{{ route('admin.faqs.index') }}" class="inline-flex items-center px-3 py-1.5 text-sm font-medium text-slate-600 hover:text-slate-900 bg-white hover:bg-slate-50 rounded-lg border border-slate-200 transition">
            <svg class="w-4 h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
            Retour
        </a>
    </div>

    <div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
        <!-- En-tête Premium -->
        <div class="px-6 py-5 border-b border-slate-100 bg-gradient-to-r from-amber-50 to-white">
            <div class="flex items-center gap-4">
                <div class="w-12 h-12 bg-gradient-to-br from-amber-400 to-amber-600 rounded-xl flex items-center justify-center shadow-lg shadow-amber-200">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                    </svg>
                </div>
                <div>
                    <h1 class="text-lg font-bold text-slate-800">Modifier la FAQ</h1>
                    <p class="text-sm text-slate-500">{{ Str::limit($faq->question, 50) }}</p>
                </div>
            </div>
        </div>

        <!-- Formulaire -->
        <form action="{{ route('admin.faqs.update', $faq) }}" method="POST" class="p-6">
            @csrf
            @method('PUT')

            <div class="space-y-6">
                <!-- Question -->
                <div>
                    <label for="question" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                        <span class="w-6 h-6 bg-amber-100 rounded-md flex items-center justify-center mr-2">
                            <svg class="w-3.5 h-3.5 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </span>
                        Question
                    </label>
                    <input type="text" name="question" id="question" value="{{ old('question', $faq->question) }}"
                           class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-amber-500/20 focus:border-amber-500 transition @error('question') border-red-400 ring-2 ring-red-100 @enderror"
                           placeholder="Ex: Quels sont les documents requis pour l'inscription ?">
                    @error('question')
                        <p class="mt-2 text-sm text-red-600 flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Réponse -->
                <div>
                    <label for="reponse" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                        <span class="w-6 h-6 bg-amber-100 rounded-md flex items-center justify-center mr-2">
                            <svg class="w-3.5 h-3.5 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h7"/>
                            </svg>
                        </span>
                        Reponse
                    </label>
                    <textarea name="reponse" id="reponse" rows="5"
                              class="w-full px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-amber-500/20 focus:border-amber-500 transition resize-none @error('reponse') border-red-400 ring-2 ring-red-100 @enderror"
                              placeholder="Entrez la reponse detaillee...">{{ old('reponse', $faq->reponse) }}</textarea>
                    @error('reponse')
                        <p class="mt-2 text-sm text-red-600 flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Ordre -->
                <div>
                    <label for="ordre" class="flex items-center text-sm font-semibold text-slate-700 mb-2">
                        <span class="w-6 h-6 bg-slate-100 rounded-md flex items-center justify-center mr-2">
                            <svg class="w-3.5 h-3.5 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16V4m0 0L3 8m4-4l4 4m6 0v12m0 0l4-4m-4 4l-4-4"/>
                            </svg>
                        </span>
                        Ordre d'affichage
                    </label>
                    <input type="number" name="ordre" id="ordre" value="{{ old('ordre', $faq->ordre) }}" min="0"
                           class="w-32 px-4 py-3 border border-slate-200 rounded-xl text-slate-900 placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-sky-500/20 focus:border-sky-500 transition @error('ordre') border-red-400 ring-2 ring-red-100 @enderror">
                    <p class="mt-2 text-xs text-slate-500">Les FAQs sont triees par ordre croissant</p>
                    @error('ordre')
                        <p class="mt-2 text-sm text-red-600 flex items-center">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            {{ $message }}
                        </p>
                    @enderror
                </div>

                <!-- Statut -->
                <div class="bg-gradient-to-r from-slate-50 to-white rounded-xl p-5 border border-slate-100">
                    <label class="relative flex items-start gap-4 cursor-pointer">
                        <input type="hidden" name="actif" value="0">
                        <div class="relative">
                            <input type="checkbox" name="actif" value="1" {{ old('actif', $faq->actif) ? 'checked' : '' }}
                                   class="sr-only peer">
                            <div class="w-11 h-6 bg-slate-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-amber-500/20 rounded-full peer peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-slate-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-gradient-to-r peer-checked:from-emerald-400 peer-checked:to-emerald-500"></div>
                        </div>
                        <div>
                            <span class="text-sm font-bold text-slate-800">FAQ active</span>
                            <p class="text-sm text-slate-500 mt-0.5">La FAQ sera visible sur le site</p>
                        </div>
                    </label>
                </div>
            </div>

            <!-- Actions -->
            <div class="flex items-center justify-between pt-6 mt-6 border-t border-slate-100">
                <a href="{{ route('admin.faqs.index') }}" class="text-sm font-medium text-slate-500 hover:text-slate-700 transition">
                    Annuler
                </a>
                <button type="submit" class="inline-flex items-center px-5 py-2.5 bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white text-sm font-bold rounded-xl transition shadow-lg shadow-red-200">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    Enregistrer les modifications
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
