@extends('layouts.admin')

@section('page-title', 'Tableau de bord')

@section('content')
<!-- Bienvenue -->
<div class="bg-gradient-to-r from-red-600 to-red-700 rounded-2xl p-6 mb-8 shadow-lg">
    <div class="flex items-center justify-between">
        <div>
            <h2 class="text-2xl font-bold text-white">Bienvenue sur Mad Academy</h2>
            <p class="text-red-100 mt-1">Gérez votre établissement depuis ce tableau de bord</p>
        </div>
        <div class="hidden sm:block">
            <div class="w-16 h-16 bg-white/20 rounded-2xl flex items-center justify-center">
                <span class="text-3xl font-bold text-white">MA</span>
            </div>
        </div>
    </div>
</div>

<!-- Cartes Statistiques -->
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
    <!-- Programmes -->
    <div class="bg-white rounded-2xl shadow-lg border border-slate-100 p-6 relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-gradient-to-br from-sky-100 to-transparent rounded-bl-full opacity-50"></div>
        <div class="relative">
            <div class="w-14 h-14 bg-gradient-to-br from-sky-400 to-sky-600 rounded-2xl flex items-center justify-center mb-4 shadow-lg shadow-sky-200">
                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
                </svg>
            </div>
            <p class="text-sm font-semibold text-slate-500 uppercase tracking-wide">Programmes</p>
            <p class="text-4xl font-bold text-slate-800 mt-1">{{ $stats['programmes'] }}</p>
            <p class="text-sm text-slate-500 mt-2">Formations BTS</p>
            <a href="{{ route('admin.programmes.index') }}" class="inline-flex items-center mt-4 text-sm font-bold text-sky-600 hover:text-sky-700">
                Voir tout →
            </a>
        </div>
    </div>

    <!-- Inscriptions -->
    <div class="bg-white rounded-2xl shadow-lg border border-slate-100 p-6 relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-gradient-to-br from-red-100 to-transparent rounded-bl-full opacity-50"></div>
        <div class="relative">
            <div class="flex items-start justify-between">
                <div class="w-14 h-14 bg-gradient-to-br from-red-500 to-red-600 rounded-2xl flex items-center justify-center mb-4 shadow-lg shadow-red-200">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
                    </svg>
                </div>
                @if($stats['inscriptions_new'] > 0)
                    <span class="bg-red-500 text-white text-xs font-bold px-3 py-1.5 rounded-full animate-pulse">
                        {{ $stats['inscriptions_new'] }} nouvelles
                    </span>
                @endif
            </div>
            <p class="text-sm font-semibold text-slate-500 uppercase tracking-wide">Inscriptions</p>
            <p class="text-4xl font-bold text-slate-800 mt-1">{{ $stats['inscriptions'] }}</p>
            <p class="text-sm text-slate-500 mt-2">Candidatures reçues</p>
            <a href="{{ route('admin.inscriptions.index') }}" class="inline-flex items-center mt-4 text-sm font-bold text-red-600 hover:text-red-700">
                Gérer →
            </a>
        </div>
    </div>

    <!-- Messages -->
    <div class="bg-white rounded-2xl shadow-lg border border-slate-100 p-6 relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-gradient-to-br from-emerald-100 to-transparent rounded-bl-full opacity-50"></div>
        <div class="relative">
            <div class="flex items-start justify-between">
                <div class="w-14 h-14 bg-gradient-to-br from-emerald-400 to-emerald-600 rounded-2xl flex items-center justify-center mb-4 shadow-lg shadow-emerald-200">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                    </svg>
                </div>
                @if($stats['messages_unread'] > 0)
                    <span class="bg-sky-500 text-white text-xs font-bold px-3 py-1.5 rounded-full">
                        {{ $stats['messages_unread'] }} non lus
                    </span>
                @endif
            </div>
            <p class="text-sm font-semibold text-slate-500 uppercase tracking-wide">Messages</p>
            <p class="text-4xl font-bold text-slate-800 mt-1">{{ $stats['messages'] }}</p>
            <p class="text-sm text-slate-500 mt-2">Messages reçus</p>
            <a href="{{ route('admin.messages.index') }}" class="inline-flex items-center mt-4 text-sm font-bold text-emerald-600 hover:text-emerald-700">
                Consulter →
            </a>
        </div>
    </div>

    <!-- En attente -->
    <div class="bg-white rounded-2xl shadow-lg border border-slate-100 p-6 relative overflow-hidden">
        <div class="absolute top-0 right-0 w-32 h-32 bg-gradient-to-br from-amber-100 to-transparent rounded-bl-full opacity-50"></div>
        <div class="relative">
            <div class="w-14 h-14 bg-gradient-to-br from-amber-400 to-amber-600 rounded-2xl flex items-center justify-center mb-4 shadow-lg shadow-amber-200">
                <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
            </div>
            <p class="text-sm font-semibold text-slate-500 uppercase tracking-wide">En attente</p>
            <p class="text-4xl font-bold text-slate-800 mt-1">{{ $stats['inscriptions_new'] }}</p>
            <p class="text-sm text-slate-500 mt-2">À traiter rapidement</p>
            <a href="{{ route('admin.inscriptions.index') }}" class="inline-flex items-center mt-4 text-sm font-bold text-amber-600 hover:text-amber-700">
                Traiter →
            </a>
        </div>
    </div>
</div>

<!-- Grille principale -->
<div class="grid grid-cols-1 xl:grid-cols-3 gap-6 mb-8">
    <!-- Inscriptions récentes -->
    <div class="xl:col-span-2">
        <div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
            <div class="px-6 py-5 border-b border-slate-100 bg-gradient-to-r from-red-50 to-white flex items-center justify-between">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-red-500 to-red-600 rounded-xl flex items-center justify-center shadow-md">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-slate-800">Dernières inscriptions</h3>
                        <p class="text-sm text-slate-500">Les 5 plus récentes</p>
                    </div>
                </div>
                <a href="{{ route('admin.inscriptions.index') }}" class="px-4 py-2 bg-red-100 text-red-700 text-sm font-bold rounded-lg hover:bg-red-200 transition">
                    Voir tout
                </a>
            </div>
            <div class="divide-y divide-slate-100">
                @forelse($recentInscriptions as $inscription)
                    <div class="px-6 py-4 hover:bg-slate-50 transition-colors flex items-center justify-between">
                        <div class="flex items-center gap-4">
                            <div class="w-12 h-12 bg-gradient-to-br from-slate-200 to-slate-300 rounded-full flex items-center justify-center shadow-inner">
                                <span class="text-sm font-bold text-slate-600">{{ strtoupper(substr($inscription->prenom, 0, 1) . substr($inscription->nom, 0, 1)) }}</span>
                            </div>
                            <div>
                                <p class="font-bold text-slate-800">{{ $inscription->nom }} {{ $inscription->prenom }}</p>
                                <p class="text-sm text-slate-500">{{ $inscription->programme->titre ?? 'Programme non défini' }}</p>
                            </div>
                        </div>
                        <div class="flex items-center gap-3">
                            @php
                                $statutConfig = [
                                    'en_attente' => ['label' => 'En attente', 'bg' => 'bg-amber-100', 'text' => 'text-amber-700', 'border' => 'border-amber-200'],
                                    'acceptee' => ['label' => 'Acceptée', 'bg' => 'bg-emerald-100', 'text' => 'text-emerald-700', 'border' => 'border-emerald-200'],
                                    'refusee' => ['label' => 'Refusée', 'bg' => 'bg-red-100', 'text' => 'text-red-700', 'border' => 'border-red-200'],
                                ];
                                $config = $statutConfig[$inscription->statut] ?? ['label' => $inscription->statut, 'bg' => 'bg-slate-100', 'text' => 'text-slate-600', 'border' => 'border-slate-200'];
                            @endphp
                            <span class="text-xs font-bold px-3 py-1.5 rounded-full border {{ $config['bg'] }} {{ $config['text'] }} {{ $config['border'] }}">
                                {{ $config['label'] }}
                            </span>
                            <a href="{{ route('admin.inscriptions.show', $inscription) }}" class="w-10 h-10 flex items-center justify-center rounded-lg text-slate-400 hover:text-red-600 hover:bg-red-50 transition">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                @empty
                    <div class="px-6 py-16 text-center">
                        <div class="w-20 h-20 bg-gradient-to-br from-slate-100 to-slate-200 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-inner">
                            <svg class="w-10 h-10 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"/>
                            </svg>
                        </div>
                        <p class="text-lg font-bold text-slate-600">Aucune inscription</p>
                        <p class="text-sm text-slate-400 mt-1">Les nouvelles candidatures apparaîtront ici</p>
                    </div>
                @endforelse
            </div>
        </div>
    </div>

    <!-- Messages récents -->
    <div>
        <div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
            <div class="px-6 py-5 border-b border-slate-100 bg-gradient-to-r from-sky-50 to-white flex items-center justify-between">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 bg-gradient-to-br from-sky-400 to-sky-600 rounded-xl flex items-center justify-center shadow-md">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-slate-800">Messages</h3>
                        <p class="text-sm text-slate-500">Récents</p>
                    </div>
                </div>
            </div>
            <div class="divide-y divide-slate-100">
                @forelse($recentMessages as $message)
                    <a href="{{ route('admin.messages.show', $message) }}" class="block px-6 py-4 hover:bg-slate-50 transition-colors">
                        <div class="flex items-start gap-3">
                            @if(!$message->lu)
                                <span class="w-3 h-3 bg-sky-500 rounded-full mt-1.5 flex-shrink-0 animate-pulse shadow-lg shadow-sky-200"></span>
                            @else
                                <span class="w-3 h-3 bg-slate-200 rounded-full mt-1.5 flex-shrink-0"></span>
                            @endif
                            <div class="min-w-0 flex-1">
                                <p class="font-bold text-slate-800 truncate {{ $message->lu ? 'text-slate-600 font-semibold' : '' }}">{{ $message->nom }}</p>
                                <p class="text-sm text-slate-500 truncate">{{ $message->sujet }}</p>
                                <p class="text-xs text-slate-400 mt-1">{{ $message->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                    </a>
                @empty
                    <div class="px-6 py-16 text-center">
                        <div class="w-20 h-20 bg-gradient-to-br from-slate-100 to-slate-200 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-inner">
                            <svg class="w-10 h-10 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <p class="text-lg font-bold text-slate-600">Aucun message</p>
                        <p class="text-sm text-slate-400 mt-1">Les messages apparaîtront ici</p>
                    </div>
                @endforelse
            </div>
            <div class="px-6 py-4 bg-slate-50 border-t border-slate-100">
                <a href="{{ route('admin.messages.index') }}" class="flex items-center justify-center text-sm font-bold text-sky-600 hover:text-sky-700">
                    Voir tous les messages →
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Actions rapides -->
<div class="bg-white rounded-2xl shadow-lg border border-slate-100 overflow-hidden">
    <div class="px-6 py-5 border-b border-slate-100 bg-gradient-to-r from-slate-50 to-white">
        <h3 class="text-lg font-bold text-slate-800">Actions rapides</h3>
        <p class="text-sm text-slate-500">Accédez rapidement aux fonctionnalités principales</p>
    </div>
    <div class="p-6">
        <div class="grid grid-cols-2 sm:grid-cols-4 gap-4">
            <a href="{{ route('admin.programmes.create') }}" class="group flex flex-col items-center p-6 bg-gradient-to-br from-sky-50 to-white border-2 border-sky-100 rounded-2xl hover:border-sky-300 hover:shadow-xl hover:shadow-sky-100/50 transition-all">
                <div class="w-16 h-16 bg-gradient-to-br from-sky-400 to-sky-600 rounded-2xl flex items-center justify-center mb-4 shadow-lg shadow-sky-200 group-hover:scale-110 transition-transform">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                    </svg>
                </div>
                <span class="text-sm font-bold text-slate-700 text-center">Nouveau programme</span>
            </a>

            <a href="{{ route('admin.faqs.create') }}" class="group flex flex-col items-center p-6 bg-gradient-to-br from-amber-50 to-white border-2 border-amber-100 rounded-2xl hover:border-amber-300 hover:shadow-xl hover:shadow-amber-100/50 transition-all">
                <div class="w-16 h-16 bg-gradient-to-br from-amber-400 to-amber-600 rounded-2xl flex items-center justify-center mb-4 shadow-lg shadow-amber-200 group-hover:scale-110 transition-transform">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.228 9c.549-1.165 2.03-2 3.772-2 2.21 0 4 1.343 4 3 0 1.4-1.278 2.575-3.006 2.907-.542.104-.994.54-.994 1.093m0 3h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <span class="text-sm font-bold text-slate-700 text-center">Nouvelle FAQ</span>
            </a>

            <a href="{{ route('admin.settings.general') }}" class="group flex flex-col items-center p-6 bg-gradient-to-br from-slate-50 to-white border-2 border-slate-200 rounded-2xl hover:border-slate-300 hover:shadow-xl hover:shadow-slate-100/50 transition-all">
                <div class="w-16 h-16 bg-gradient-to-br from-slate-500 to-slate-700 rounded-2xl flex items-center justify-center mb-4 shadow-lg shadow-slate-200 group-hover:scale-110 transition-transform">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                </div>
                <span class="text-sm font-bold text-slate-700 text-center">Paramètres</span>
            </a>

            <a href="{{ route('admin.settings.email') }}" class="group flex flex-col items-center p-6 bg-gradient-to-br from-red-50 to-white border-2 border-red-100 rounded-2xl hover:border-red-300 hover:shadow-xl hover:shadow-red-100/50 transition-all">
                <div class="w-16 h-16 bg-gradient-to-br from-red-500 to-red-600 rounded-2xl flex items-center justify-center mb-4 shadow-lg shadow-red-200 group-hover:scale-110 transition-transform">
                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"/>
                    </svg>
                </div>
                <span class="text-sm font-bold text-slate-700 text-center">Config. email</span>
            </a>
        </div>
    </div>
</div>
@endsection
