<?php

namespace App\Services;

use App\Models\Programme;
use App\Models\Inscription;
use App\Models\Message;

class StatsService
{
    public function getDashboardStats(): array
    {
        return [
            'programmes' => Programme::count(),
            'inscriptions' => Inscription::count(),
            'inscriptions_new' => Inscription::where('statut', 'en_attente')->count(),
            'messages' => Message::count(),
            'messages_unread' => Message::where('lu', false)->count(),
        ];
    }
}
