<?php

namespace App\Http\Controllers;

use App\Models\Programme;
use App\Models\Inscription;
use App\Models\Message;
use App\Models\Setting;
use App\Models\Statistic;
use App\Models\Faq;
use App\Models\DocumentRequis;
use Illuminate\Http\Request;

class FrontController extends Controller
{
    public function accueil()
    {
        $programmes = Programme::where('statut', true)->get();
        $settings = Setting::first();
        $statistics = Statistic::actif()->ordre()->get();
        return view('front.accueil', compact('programmes', 'settings', 'statistics'));
    }

    public function aPropos()
    {
        return view('front.a-propos');
    }

    public function programmes()
    {
        $programmes = Programme::where('statut', true)->get();
        $statistics = Statistic::actif()->ordre()->get();
        return view('front.programmes', compact('programmes', 'statistics'));
    }

    public function inscription(Request $request)
    {
        $programmes = Programme::where('statut', true)->get();
        $programmeId = $request->query('programme');
        $documentsRequis = DocumentRequis::actif()->ordre()->get();
        return view('front.inscription', compact('programmes', 'programmeId', 'documentsRequis'));
    }

    public function inscriptionStore(Request $request)
    {
        $validated = $request->validate([
            'nom' => 'required|string|max:255',
            'prenom' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'telephone' => 'required|string|max:20',
            'programme_id' => 'required|exists:programmes,id',
            'message' => 'nullable|string|max:1000',
        ]);

        Inscription::create($validated);

        return redirect()->route('inscription')->with('success', 'Votre inscription a été enregistrée avec succès. Nous vous contacterons prochainement.');
    }

    public function contact()
    {
        $faqs = Faq::actif()->ordre()->get();
        return view('front.contact', compact('faqs'));
    }

    public function contactStore(Request $request)
    {
        $validated = $request->validate([
            'nom' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'sujet' => 'required|string|max:255',
            'message' => 'required|string|max:2000',
        ]);

        Message::create($validated);

        return redirect()->route('contact')->with('success', 'Votre message a été envoyé avec succès. Nous vous répondrons dans les plus brefs délais.');
    }
}
