<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Programme;
use Illuminate\Http\Request;

class ProgrammeController extends Controller
{
    public function index()
    {
        $programmes = Programme::latest()->get();
        return view('admin.programmes.index', compact('programmes'));
    }

    public function create()
    {
        return view('admin.programmes.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'titre' => 'required|string|max:255',
            'description' => 'required|string',
            'pension' => 'required|numeric|min:0',
            'statut' => 'boolean',
        ]);

        Programme::create($validated);

        return redirect()->route('admin.programmes.index')->with('success', 'Programme créé avec succès.');
    }

    public function show(Programme $programme)
    {
        return view('admin.programmes.show', compact('programme'));
    }

    public function edit(Programme $programme)
    {
        return view('admin.programmes.edit', compact('programme'));
    }

    public function update(Request $request, Programme $programme)
    {
        $validated = $request->validate([
            'titre' => 'required|string|max:255',
            'description' => 'required|string',
            'pension' => 'required|numeric|min:0',
            'statut' => 'boolean',
        ]);

        $programme->update($validated);

        return redirect()->route('admin.programmes.index')->with('success', 'Programme modifié avec succès.');
    }

    public function destroy(Programme $programme)
    {
        $programme->delete();

        return redirect()->route('admin.programmes.index')->with('success', 'Programme supprimé avec succès.');
    }
}
